program eight21;

{Proper delta-sigma modulation:
for each sample:
  if sample > error
    then output=max, error=error + max - sample
    else output=min, error=error + min - sample
this assumes that max=1 and min =-1

this version 8x oversampling
}

uses
  support;

var
  inf,outf:file;
  fsize:word;
  w:word;
  bit,targ,b,outb,cnt,mask:byte;
  err:longint;
  samp:integer;
  os:byte;


begin
  if not fileexists(paramstr(1)) then halt;
  assign(inf,paramstr(1));
  reset(inf,1);
  assign(outf,'out_100.sdm');
  rewrite(outf,1);
  cnt:=0; targ:=0; err:=0;
  while not eof(inf) do begin
    blockread(inf,b,1);
    {convert to signed}
    samp:=b-128;
    for os:=0 to 7 do begin
      if samp>err
        then begin
          outb:=1;
          err:=err + (127 - samp);
        end else begin
          outb:=0;
          err:=err + (-128 - samp);
        end;
      asm
        mov al,outb
        or  targ,al
      end;
      inc(cnt);
      if cnt=8 then begin
        blockwrite(outf,targ,1);
        cnt:=0;
        targ:=0;
      end else
        targ:=targ shl 1;
    end;
  end;
  close(inf);
  close(outf);
end.